/*
 * Decompiled with CFR 0.152.
 */
package svenhjol.charm.module;

import net.minecraft.entity.Entity;
import net.minecraft.entity.passive.BatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import svenhjol.charm.base.CharmModule;
import svenhjol.charm.base.helper.ItemNBTHelper;
import svenhjol.charm.base.helper.PlayerHelper;
import svenhjol.charm.base.iface.Config;
import svenhjol.charm.base.iface.Module;
import svenhjol.charm.client.BatBucketsClient;
import svenhjol.charm.item.BatBucketItem;

@Module(mod="charm", client=BatBucketsClient.class, description="Right-click a bat with a bucket to capture it. Right-click again to release it and locate entities around you.", hasSubscriptions=true)
public class BatBuckets
extends CharmModule {
    public static BatBucketItem BAT_BUCKET_ITEM;
    @Config(name="Glowing time", description="Number of seconds that entities will receive the glowing effect.")
    public static int glowingTime;
    @Config(name="Viewing range", description="Range (in blocks) in which entities will glow.")
    public static int glowingRange;

    @Override
    public void register() {
        BAT_BUCKET_ITEM = new BatBucketItem(this);
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        if (!event.isCanceled()) {
            this.tryCapture(event.getPlayer(), event.getWorld(), event.getHand(), event.getTarget());
        }
    }

    private void tryCapture(PlayerEntity player, World world, Hand hand, Entity entity) {
        if (!entity.field_70170_p.field_72995_K && entity instanceof BatEntity && ((BatEntity)entity).func_110143_aJ() > 0.0f) {
            BatEntity bat = (BatEntity)entity;
            ItemStack held = player.func_184586_b(hand);
            if (held.func_190926_b() || held.func_77973_b() != Items.field_151133_ar) {
                return;
            }
            ItemStack batBucket = new ItemStack((IItemProvider)BAT_BUCKET_ITEM);
            CompoundNBT tag = bat.serializeNBT();
            ItemNBTHelper.setCompound(batBucket, "stored_bat", tag);
            if (held.func_190916_E() == 1) {
                player.func_184611_a(hand, batBucket);
            } else {
                held.func_190918_g(1);
                PlayerHelper.addOrDropStack(player, batBucket);
            }
            player.func_184609_a(hand);
            entity.func_70106_y();
        }
    }

    static {
        glowingTime = 10;
        glowingRange = 24;
    }
}

